/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import java.util.HashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerNPCFollowerSetup;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleFollower;

public class GuiNpcFollowerSetup
extends GuiContainerNPCInterface2 {
    private final RoleFollower role;

    public GuiNpcFollowerSetup(EntityNPCInterface npc, ContainerNPCFollowerSetup container) {
        super(npc, (Container)container);
        this.field_147000_g = 200;
        this.role = (RoleFollower)npc.advanced.roleInterface;
        this.setBackground("followersetup.png");
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 7: {
                this.role.infiniteDays = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 8: {
                this.role.disableGui = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 9: {
                this.role.refuseSoulStone = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 10: {
                this.role.killed();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        GuiNpcTextField textField;
        int days;
        super.func_73866_w_();
        int x = this.field_147003_i + 66;
        int y = this.field_147009_r + 39;
        int lId = 0;
        this.addLabel(new GuiNpcLabel(lId++, "follower.hire", x, y - 12));
        for (int i = 0; i < 3; ++i) {
            days = this.role.rates.getOrDefault(i, 1);
            this.addLabel(new GuiNpcLabel(lId++, "#" + (i + 1), x - 34, y + i * 25 + 4));
            textField = new GuiNpcTextField(i, (GuiScreen)this, this.field_146289_q, x, y + i * 25, 24, 16, "" + days);
            textField.setMinMaxDefault(1L, Integer.MAX_VALUE, days);
            this.setHoverText(new TextComponentTranslation("follower.hover.days", new Object[]{"" + (i + 1)}).func_150254_d(), new Object[0]);
            this.addTextField(textField);
        }
        textField = new GuiNpcTextField(3, (GuiScreen)this, this.field_146289_q, x += 34, y -= 33, 286, 16, this.role.dialogHire);
        textField.setHoverText("follower.hover.mes.hire", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(4, (GuiScreen)this, this.field_146289_q, x, y += 19, 286, 16, this.role.dialogFarewell);
        textField.setHoverText("follower.hover.mes.let.go", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(5, (GuiScreen)this, this.field_146289_q, x, y += 19, 286, 16, this.role.dialogFired);
        textField.setHoverText("follower.hover.mes.fired", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcCheckBox(7, x += 73, y += 19, 120, 14, "follower.infiniteDays", null, this.role.infiniteDays);
        button.setHoverText("follower.hover.infinite", new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(8, x, y += 16, 120, 14, "follower.guiDisabled", null, this.role.disableGui);
        button.setHoverText("follower.hover.disable.gui", new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(9, x, y += 16, 120, 14, "follower.allowSoulstone", null, this.role.refuseSoulStone);
        button.setHoverText("follower.hover.soulstone", new TextComponentTranslation("item.npcsoulstoneempty.name", new Object[0]).func_150254_d());
        this.addButton(button);
        textField = new GuiNpcTextField(6, (GuiScreen)this, this.field_146289_q, x + 45, y += 18, 60, 16, "" + this.role.rentalMoney);
        textField.setMinMaxDefault(0L, 9999999999L, this.role.rentalMoney);
        textField.setHoverText("follower.hover.money", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "gui.money", x, y + 4));
        this.addLabel(new GuiNpcLabel(lId++, "#4", x + 33, y + 4));
        this.addLabel(new GuiNpcLabel(lId++, CustomNpcs.displayCurrencies, x + 107, y + 4));
        days = this.role.rates.getOrDefault(3, 1);
        textField = new GuiNpcTextField(7, (GuiScreen)this, this.field_146289_q, x + 120, y, 24, 16, "" + days);
        textField.setMinMaxDefault(1L, Integer.MAX_VALUE, days);
        textField.setHoverText("follower.hover.days", "4");
        this.addTextField(textField);
        textField = new GuiNpcTextField(8, (GuiScreen)this, this.field_146289_q, x + 45, y += 19, 24, 16, "" + this.role.inventory.func_70302_i_());
        textField.setMinMaxDefault(0L, 9L, this.role.inventory.func_70302_i_());
        textField.setHoverText("follower.hover.inventory", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "gui.things", x, y + 4));
        button = new GuiNpcButton(10, x, y + 19, 100, 20, "remote.reset");
        button.setHoverText("follower.hover.reset", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 1) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
    }

    @Override
    public void save() {
        int size;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < 3; ++i) {
            int days = 1;
            if (!this.getTextField(i).isEmpty() && this.getTextField(i).isInteger()) {
                days = this.getTextField(i).getInteger();
            }
            if (days <= 0) {
                days = 1;
            }
            map.put(i, days);
        }
        this.role.rentalMoney = this.getTextField(6).getInteger();
        if (this.role.rentalMoney > 0) {
            int days = 1;
            if (!this.getTextField(7).isEmpty() && this.getTextField(7).isInteger()) {
                days = this.getTextField(7).getInteger();
            }
            if (days <= 0) {
                days = 1;
            }
            map.put(3, days);
        }
        this.role.rates = map;
        this.role.dialogHire = this.getTextField(3).getFullText();
        this.role.dialogFarewell = this.getTextField(4).getFullText();
        this.role.dialogFired = this.getTextField(5).getFullText();
        int n = size = this.role.disableGui ? 0 : this.getTextField(8).getInteger();
        if (this.role.inventory.func_70302_i_() != size) {
            this.role.inventory = new NpcMiscInventory(size);
        }
        Client.sendData(EnumPacketServer.RoleSave, this.role.save(new NBTTagCompound()));
    }
}

